#ifndef _TROPHIES_H
#define _TROPHIES_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	struct TrophyGameInfo
	{
		int numGroups;
		int numTrophies;
		int numPlatinum;
		int numGold;
		int numSilver;
		int numBronze;
		const char* title;
		const char* description;
	};

	struct GroupDetails
	{
		int groupId;
		int numTrophies;
		int numPlatinum;
		int numGold;
		int numSilver;
		int numBronze;
		int iconWidth;
		int iconHeight;
		int iconDataSize;
		void* iconData;
		const char* title;
		const char* description;
	};

	struct GroupData
	{
		int groupId;
		int unlockedTrophies;
		int unlockedPlatinum;
		int unlockedGold;
		int unlockedSilver;
		int unlockedBronze;
		int progressPercentage;
	};

	struct TrophyDetails
	{
		int trophyId;
		int trophyGrade;
		int groupId;
		bool hidden;
		const char* name;
		const char* description;
	};

	struct TrophyData
	{
		int trophyId;
		bool unlocked;
		SceRtcTick timestamp;
		int iconWidth;
		int iconHeight;
		int iconDataSize;
		void* iconData;
	};

	struct TrophyProgress
	{
		int unlockedTrophies;
		int unlockedPlatinum;
		int unlockedGold;
		int unlockedSilver;
		int unlockedBronze;
		int progressPercentage;
	};

	PRX_EXPORT bool PrxTrophyGetLastError(ResultCode* result);

	PRX_EXPORT bool PrxTrophyRegisterPackIsBusy();
	PRX_EXPORT bool PrxTrophyRefreshGroupInfoIsBusy();
	PRX_EXPORT bool PrxTrophyRefreshTrophyInfoIsBusy();
	PRX_EXPORT bool PrxTrophyRefreshProgressIsBusy();
	
	PRX_EXPORT ErrorCode PrxTrophyGetGameInfo(TrophyGameInfo* info);

	PRX_EXPORT void PrxTrophyLockList();
	PRX_EXPORT void PrxTrophyUnlockList();

	PRX_EXPORT int PrxTrophyGetGroupDetailsCount();
	PRX_EXPORT ErrorCode PrxTrophyGetGroupDetails(int index, GroupDetails* details);
	PRX_EXPORT int PrxTrophyGetGroupDataCount();
	PRX_EXPORT ErrorCode PrxTrophyGetGroupData(int index, GroupData* data);

	PRX_EXPORT ErrorCode PrxTrophyRefreshTrophyInfo();
	PRX_EXPORT int PrxTrophyGetTrophyDetailsCount();
	PRX_EXPORT ErrorCode PrxTrophyGetTrophyDetails(int index, TrophyDetails* details);
	PRX_EXPORT int PrxTrophyGetTrophyDataCount();
	PRX_EXPORT ErrorCode PrxTrophyGetTrophyData(int index, TrophyData* data);

	PRX_EXPORT ErrorCode PrxTrophyRefreshProgress();
	PRX_EXPORT ErrorCode PrxTrophyGetProgress(TrophyProgress* info);

	PRX_EXPORT ErrorCode PrxTrophyAward(int index);

	PRX_EXPORT ErrorCode PrxTrophyRefreshGroupInfo();
	PRX_EXPORT ErrorCode PrxTrophyGetGroupInfo();

	class CachedTrophies
	{
		SimpleLock m_Lock;
		ResultCode m_LastResult;
		bool m_RegisterTrophyPackBusy;
		bool m_RefreshGroupInfoBusy;
		bool m_RefreshTrophyInfoBusy;
		bool m_RefreshProgressBusy;
		bool m_FirstTimeTrophySetup;		// true when registering the first user trophy set


		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::TrophyGameInfo> m_FutureGameInfo;
		int m_GroupInfoGetCount;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::TrophyInfo>* m_FutureTrophyInfo;
		sce::Toolkit::NP::Utilities::Future<SceNpTrophyGameData> m_FutureProgress;

		std::string m_GameInfoTitle;
		std::string m_GameInfoDesc;
		TrophyGameInfo m_CachedGameInfo;
		TrophyProgress m_CachedProgress;

		struct CachedGroupDetails
		{
			SceNpTrophyGroupId groupId;
			SceUInt32 numTrophies;
			SceUInt32 numPlatinum;
			SceUInt32 numGold;
			SceUInt32 numSilver;
			SceUInt32 numBronze;
			SceUInt32 iconWidth;
			SceUInt32 iconHeight;
			SceUInt32 iconDataSize;
			void* iconData;
			std::string title;
			std::string description;
		};

		struct CachedGroupData
		{
			SceNpTrophyGroupId groupId;
			SceUInt32 unlockedTrophies;
			SceUInt32 unlockedPlatinum;
			SceUInt32 unlockedGold;
			SceUInt32 unlockedSilver;
			SceUInt32 unlockedBronze;
			SceUInt32 progressPercentage;
		};

		struct CachedTrophyDetails
		{
			SceNpTrophyId trophyId;
			SceNpTrophyGrade trophyGrade;
			SceNpTrophyGroupId groupId;
			SceBool hidden;
			std::string name;
			std::string description;
		};

		struct CachedTrophyData
		{
			SceNpTrophyId trophyId;
			SceBool unlocked;
			SceRtcTick timestamp;
			SceUInt32 iconWidth;
			SceUInt32 iconHeight;
			SceUInt32 iconDataSize;
			void* iconData;
		};

		std::vector<CachedGroupDetails*> m_CachedGroupDetails;
		std::vector<CachedGroupData*> m_CachedGroupData;
		std::vector<CachedTrophyDetails*> m_CachedTrophyDetails;
		std::vector<CachedTrophyData*> m_CachedTrophyData;

	public:
		CachedTrophies();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		bool RegisterTrophyPackIsBusy();
		bool RefreshGroupInfoIsBusy();
		bool RefreshTrophyInfoIsBusy();
		bool RefreshProgressIsBusy();

		ErrorCode RegisterTrophyPack(bool cacheIcons);

		ErrorCode GetGameInfo(TrophyGameInfo* info);

		void Lock();
		void Unlock();
		ErrorCode RefreshTrophyInfo();
		int GetTrophyDetailsCount() const;
		ErrorCode GetTrophyDetails(unsigned int index, TrophyDetails* info);
		int GetTrophyDataCount() const;
		ErrorCode GetTrophyData(unsigned int index, TrophyData* info);

		ErrorCode RefreshGroupInfo();
		int GetGroupDetailsCount() const;
		ErrorCode GetGroupDetails(unsigned int index, GroupDetails* info);
		int GetGroupDataCount() const;
		ErrorCode GetGroupData(unsigned int index, GroupData* info);

		ErrorCode RefreshProgress();
		ErrorCode GetProgress(TrophyProgress* info);

		ErrorCode AwardTrophy(int index);

	private:
		void CreateGroupInfo(int size);
		void DestroyGroupInfo();
		void ClearGroupInfoList();

		void CreateTrophyInfo(int size);
		void DestroyTrophyInfo();
		void ClearTrophyInfoList();
	};

	extern CachedTrophies gTrophies;
}

#endif // _TROPHIES_H
